#!/usr/bin/env python
"""
Program Roto-Sketch (współdziała z enkoderem obrotowym).
Enkoder 1 jest podłączony do wejść 6 i 7.
Enkoder 2 jest podłączony do wejść 4 i 5.
Przełącznik przechylny jest podłączony do wejścia 3.
"""

import colorsys
from smbus import SMBus
import os, sys, pygame
from pygame.locals import *
import piface.pfio as pfio  # Biblioteka piface
import subprocess

pfio.init()         # Inicjowanie biblioteki piface
pygame.init()       # Inicjowanie biblioteki pygame
os.environ['SDL_VIDEO_WINDOW_POS'] = 'center'
pygame.display.set_caption("Roto-Sketch")
screen = pygame.display.set_mode([512,512],0,32)
lastEncoder = [0,0]
current_reading = [256,256]
last_reading = [256,256,256,256] # Definiowanie początkowej pozycji 
col = (0,0,0)
colCursor = (128,128,128)
background = (255, 255, 255)  # Kolor tła
picture = 1 # Numer grafiki
fileName ="name"
lastPort = -1
 
def main():
 global current_reading, last_reading
 print "Oto dostępne klawisze: "
 print "R (czerwony), G (zielony), B (niebieski), Y (żółty), M (magenta), "
 print "P (zielononiebieski), K (czarny), W (biały) służą do ustawiania kolorów."
 print "Spacja powoduje usunięcie zawartości ekranu."
 print "L tworzy linię do zapisanego punktu, C tworzy okrąg ze środkiem w zapisanym punkcie."
 print "S zapisuje bieżący punkt w celu późniejszego utworzenia linii lub okręgu."
 print "Przycisk Home zapisuje grafikę w pliku."
 print "# pozwala przesłać grafikę do serwisów Flickr i Facebook."
 blank_screen()
 while(True): # Działa w nieskończoność
      readEncoders()
      pygame.draw.rect(screen,col,(last_reading[0],last_reading[1],2,2),0)
      pygame.draw.line(screen,col,(last_reading[0],last_reading[1]),(current_reading[0],current_reading[1]),2)
      pygame.draw.rect(screen,colCursor,(current_reading[0],current_reading[1],2,2),0)
      last_reading[0] = current_reading[0] # Zapisywanie pozycji, aby zacząć od niej rysowanie następnym razem
      last_reading[1] = current_reading[1]
      pygame.display.update()

# Koniec głównej pętli
      
# Definicje funkcji 

# Odczyt danych z dwóch enkoderów z ząbkami przyjmującymi naprzemiennie stany 00 11
def readEncoders() : # Wyjście po wykryciu ruchu w jednym z enkoderów
    global current_reading, lastPort
    moved = False
    inc = 8
    while not moved :
        checkForQuit()
        port = pfio.read_input()
        portP = (port & 0xc0) >> 6
        lastPortP = (lastPort & 0xc0) >> 6
        for axis in range(0,2) :
          if lastPortP != portP and (lastPortP == 0 or lastPortP == 0x3) :
              if (lastPortP == 0 and portP == 0x2) or (lastPortP == 0x3 and portP == 0x1):
                  current_reading[axis] -= inc
                  moved = True
              if (lastPortP == 0x3 and portP == 0x2) or (lastPortP == 0 and portP == 0x1):
                  current_reading[axis] += inc
                  moved = True
          portP = (port & 0x30) >> 4
          lastPortP = (lastPort &0x30) >> 4
        if port &0x8 :
            blank_screen()
        lastPort = port

def blank_screen():
    screen.fill(background) # Pusty ekran
    pygame.display.update()
    
def terminate():
    print "Trwa zamykanie - proszę czekać"
    pfio.deinit() 
    pygame.quit()
    sys.exit()

def checkForQuit():
    global col, picture, last_reading, fileName
    event = pygame.event.poll()
    if event.type == pygame.QUIT :
           terminate()
    elif event.type == pygame.KEYDOWN : # Ustalanie klawisza i wykonywanie odpowiednich operacji
         if event.key == pygame.K_ESCAPE :
            terminate()
         if event.key == K_SPACE or event.key == K_DELETE:   
            blank_screen()
         if event.key == K_r : # Rysowanie w kolorze czerwonym
             col = (255, 0, 0)
         if event.key == K_g : # Rysowanie w kolorze zielonym
             col = (0, 255, 0)
         if event.key == K_b : # Rysowanie w kolorze niebieskim
             col = (0, 0, 255)
         if event.key == K_y : # Rysowanie w kolorze żółtym
             col = (255, 255, 0)
         if event.key == K_m : # Rysowanie w kolorze magenta
             col = (255, 0, 255)
         if event.key == K_p : # Rysowanie w kolorze niebieskim
             col = (0, 255, 255)
         if event.key == K_w : # Rysowanie w kolorze białym
             col = (255, 255, 255)
         if event.key == K_k : # Rysowanie w kolorze czarnym
             col = (0, 0, 0)
         if event.key == K_s : # Zapisywanie bieżącego punktu
             last_reading[2] = last_reading[0] # Zapisanie danych z enkodera X
             last_reading[3] = last_reading[1] # Zapisanie danych z enkodera Y
         if event.key == K_l : # Rysowanie linii do zapisanego punktu
             pygame.draw.line(screen,col,(last_reading[2],last_reading[3]),(last_reading[0],last_reading[1]),2)
             pygame.display.update()
         if event.key == K_c : # Rysowanie okręgu
             try :
                r = ((last_reading[0] - last_reading[2])**2 + (last_reading[1] - last_reading[3])**2 ) ** (0.5)
                pygame.draw.circle(screen,col,(last_reading[0],last_reading[1]),int(r),2)
                pygame.display.update()
             except:
                pass
         if event.key == K_HASH : # Zapisywanie zawartości katalogu w serwisach Flickr i Facebook
             print "Wysyłanie zawartości katalogu do serwisu Flickr"
             subprocess.check_output("python folders2flickr/uploadr.py",shell=True)
             print "Gotowe"
         if event.key == K_HOME : # Zapisywanie grafiki
             print "Zapisywanie grafiki w pliku"
             if picture == 1 : # Pierwsze zapisywanie grafiki w danej sesji
                fileName = raw_input("Wpisz nazwę pliku na potrzeby tej sesji ")
             try:
                 pygame.image.save(screen,'roto-sketch/'+fileName+str(picture)+'.png')
             except:
                 os.system('mkdir roto-sketch')
                 pygame.image.save(screen,'roto-sketch/'+fileName+str(picture)+'.png')
             print "Zapisywanie grafiki w pliku ",'roto-sketch/'+fileName+str(picture)+'.png'
             picture +=1;            

if __name__ == '__main__':
    main()
